import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Label;
import java.awt.Font;
import java.awt.Event;
import java.awt.Button;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.TextField;


public class HistoryProperties extends Dialog {
    Button      m_ButtonOK;
    Button      m_ButtonClear;
    TextField   m_Edit1;

    public HistoryProperties(Frame frame) {
        super(frame,false);
        this.setLayout(new BorderLayout(15,15));
        // Set Title
        setTitle("HistoryChart's Properties");
        Panel p = new Panel();
        p.setLayout(new FlowLayout(FlowLayout.CENTER,50,15));
        p.add(new FontLabel("Steps to remember:","Helvetica",Font.BOLD,20,180,30));
        p.add(m_Edit1 = new TextField(3));
        p.add(new ImagePanel(Global.m_imgAbout));
        this.add("Center",p);
        // OK Button
        p = new Panel();
        p.setLayout(new FlowLayout(FlowLayout.CENTER,15,15));
        p.add(m_ButtonOK = new Button("  Ok  "));
        p.add(m_ButtonClear = new Button("Clear History"));
        this.add("South",p);
    }

    public boolean action(Event e, Object arg) {
        if (e.target ==  m_ButtonOK) {
            int iAnz = Integer.valueOf(m_Edit1.getText()).intValue();
            Global.historyPanel.setAnzahl(iAnz);
            this.hide();
            return(true);
        }
        if (e.target ==  m_ButtonClear) {
            Global.historyPanel.clear();
            return(true);
        }
        if (e.target == m_Edit1) {
            int iAnz = Integer.valueOf(m_Edit1.getText()).intValue();
            Global.historyPanel.setAnzahl(iAnz);
            return(true);
        }
        return(false);
    }
    public void show() {
        super.show();
        m_Edit1.setText(Integer.toString(Global.historyPanel.getAnzahl()));
    }
}
